package com.agilex.healthcare.mobilehealthplatform.domain;


import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullSafeStringComparer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Date;

public class DOBDate {

    private static final Log logger = LogFactory.getLog(DOBDate.class);
    private static final String DEFAULT_FORMAT = "MMM dd, yyyy";
    private String format;
    private String value;
    private boolean isValid;


    public DOBDate(){}

    public DOBDate(Date dob) {
        this.format = "MMM dd, yyyy";
        if(dob != null) {
            this.value = this.convertDateToString(dob);
        } else {
            this.value = "";
            logger.warn("DOB was passed in as null.  Setting DOB date value to Empty String.");
        }

        this.isValid = !"".equals(this.value);
    }

    private String convertDateToString(Date dob) {
        try {
            return DateHelper.format(dob, this.format);
        } catch (Exception var3) {
            logger.warn("Unable to format date for DOB using the default " + this.format + " format.  Setting DOB date value to Empty String.");
            return "";
        }
    }

    public DOBDate(String format, String value) {
        if(format == null) {
            this.format = "MMM dd, yyyy";
        } else {
            this.format = format;
        }

        if(value == null) {
            this.value = "";
        } else {
            this.value = value;
        }

        this.isValid = !"".equals(this.value) && this.getDate() != null;
    }

    public Date getDate() {
        try {
            return DateHelper.parse(this.value, this.format);
        } catch (Exception var2) {
            logger.warn("Unable to parse date for DOB using " + this.format + " format.  Returning Null date.");
            return null;
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if(this == obj) {
            return true;
        } else if(!(obj instanceof DOBDate)) {
            return false;
        } else {
            DOBDate that = (DOBDate)obj;
            return NullSafeStringComparer.areEqual(this.format, that.format) && NullSafeStringComparer.areEqual(this.value, that.value);
        }
    }

    public int hashCode() {
        return this.value.hashCode() ^ this.format.hashCode();
    }
}
